package com.gccloud.starter.common.config.bean;

import com.gccloud.starter.common.constant.GlobalConst;
import com.google.common.collect.Sets;
import lombok.Data;

import java.util.Set;

/**
 * @author liuchengbiao
 * @date 2020-06-16 14:59
 */
@Data
public class Jwt {
    /**
     * 颁发jwt者
     */
    public String issuer;
    /**
     * 密钥
     */
    public String secret;
    /**
     * 签名算法
     */
    public String alg;
    /**
     * jwt时效（单位为秒）
     */
    public Long expiration = 7200L;
    /**
     * 默认为无状态存储
     */
    public GlobalConst.Jwt.StoreStrategy storeStrategy = GlobalConst.Jwt.StoreStrategy.NONE;
    /**
     * tokenKey
     */
    public String tokenKey = "token";
    /**
     * 是否启动jwt 秘钥安全检查
     */
    private Boolean secretCheckEnable = true;
    /**
     * 允许token携带的方式；
     * 可以将其设置为仅通过cookie访问，提高安全性
     */
    private Set<String> allowTakeMethod = Sets.newHashSet(GlobalConst.Jwt.AllowTakeMethod.COOKIES, GlobalConst.Jwt.AllowTakeMethod.HEADER, GlobalConst.Jwt.AllowTakeMethod.PARAMETER);
}


