package com.gccloud.starter.common.config.bean;

import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;

/**
 * 项目信息
 *
 * @author liuchengbiao
 * @date 2020-07-23 20:30
 */
@Data
public class Project {
    /**
     * 项目名称
     */
    @NotBlank(message = "请在配置文件中配置项目名称，如: gc.starter.project.name=国创九章数据智能云平台")
    @Length(min = 5, max = 100, message = "项目名称长度必须在5~100之间")
    private String name;
    /**
     * 项目类型
     * 移动、联通、电信等
     */
    @NotBlank(message = "请在配置文件中配置项目类型，如: gc.starter.project.type=移动 或 联通 或 电信 或 其他")
    private String type;
    /**
     * 区域
     */
    @NotBlank(message = "请在配置文件中配置项目所属区域，如: gc.starter.project.area=华东区BU")
    private String area;
    /**
     * 项目负责人
     */
    @NotBlank(message = "请在配置文件中配置项目经理姓名，如: gc.starter.project.leader=张无忌")
    @Length(min = 2, max = 10, message = "项目经理姓名长度必须在2~10之间")
    private String leader;
    /**
     * 联系电话
     */
    @NotBlank(message = "请在配置文件中配置项目经理联系电话，如: gc.starter.project.mobile=181xxxxxxxx")
    @Pattern(regexp = "[1][0-9]{10}", message = "请在配置文件中配置项目经理联系电话，如: gc.starter.project.mobile=18155164137")
    private String mobile;

    @NotBlank(message = "请在配置文件中配置项目经理邮箱信息，如: gc.starter.project.email=xiaoka@ustcinfo.com")
    private String email;
}
