package com.gccloud.starter.common.config.bean;

import lombok.Data;

/**
 * 易盾官网：http://dun.163.com
 * 易盾服务相关配置
 * @Author zhang.tianming
 * @Date 2021/10/21 14:25
 * @Version 1.0
 */
@Data
public class YiDun {
    /**
     *  SECRET_ID 和 SECRET_KEY 是产品密钥。可以登录易盾官网找到自己的凭证信息。请妥善保管，避免泄露。
     */
    private String secretId;
    private String secretKey;
    /**
     * 网易易盾发送短信的url
     */
    private String url;
    /**
     * 国内通知类短信 业务的ID。可以登录易盾官网查看此业务ID
     */
    private String businessId;
    /**
     * 短信模板ID。你需要先在易盾官网创建模板并通过审核后才能使用。模板ID需要与业务ID匹配。即，该模板属于目标业务。
     */
    private String templateId;
}
