package com.gccloud.starter.common.constant;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import java.util.List;
import java.util.Set;

/**
 * @author liuchengbiao
 * @date 2020-06-21 13:33
 */
public interface GlobalConst {
    /**
     * 控制台
     */
    interface Console {
        /**
         * 控制台line
         */
        String LINE = "----------------------------------------";
    }

    /**
     * 编码
     */
    interface Charset {
        String UTF8 = "UTF-8";
    }

    /**
     * 扫描包
     */
    interface ScanPackage {
        /**
         * DAO扫描路径
         */
        String BASE_DAO = "com.gccloud.starter.**.dao";
        /**
         * 组件扫描路径，controller、service等
         */
        String BASE_COMPONENT = "com.gccloud.starter";
    }

    /**
     * 配置文件
     */
    interface ConfigFile {
        /**
         * 系统配置文件、用于自动生成时使用
         */
        List<String> SYS_CONFIG_FILE_NAME_LIST = Lists.newArrayList("application-base.yml", "application-cas.yml", "application-druid-mysql.yml", "application-druid-oracle.yml", "application-druid-pg.yml", "application-mybatis-plus-mysql.yml", "application-mybatis-plus-oracle.yml", "application-mybatis-plus-pg.yml", "application.yml", "application-dev.yml", "application-prod.yml", "logback-spring.xml", "restart.sh", "stop.sh", "log.sh");
    }

    /**
     * 是否有子节点
     */
    interface HasChildren {
        /**
         * 有子节点
         */
        Integer YES = 1;
        /**
         * 没有子节点
         */
        Integer NO = 0;
    }

    /**
     * 删除标志位
     */
    interface DelFlag {
        /**
         * 删除
         */
        int DELETE = 1;
        /**
         * 未删除
         */
        int NOAMAL = 0;
    }

    /**
     * 用户和机构映射
     */
    interface UserOrg {
        /**
         * 用户归属机构类型
         */
        interface Type {
            /**
             * 行政机构，命名暂定
             */
            String ADMINISTRATIVE = "3";
            /**
             * 归属机构，表明用户归属
             */
            String BE_LONG = "1";
            /**
             * 归属并管理机构，表明用户不仅归属而且还是管理者
             */
            String BE_LONG_AND_MANAGE = "2";
        }
    }

    /**
     * 业务字典
     */
    interface Dict {
        /**
         * 系统业务字典
         */
        interface Sys {
            /**
             * 日志类型
             */
            String LOG_TYPE = "LOG_TYPE";
        }
    }

    /**
     * 业务字典项状态
     */
    interface DictItem {

        interface Status {
            /**
             * 正常
             */
            int NORMAL = 0;
            /**
             * 禁用
             */
            int FORBIDDEN = 1;
        }

        int DEFAULT_ORDER_NUM = 0;
    }


    /**
     * 系统日志常量
     */
    interface Log {
        /**
         * 日志状态
         */
        interface State {
            /**
             * 异常
             */
            int EXCEPTION = 1;
            /**
             * 正常
             */
            int NORMAL = 2;
        }

        /**
         * 日志类型
         */
        interface Type {
            /**
             * 新增
             */
            int INSERT = 1;
            /**
             * 删除
             */
            int DELETE = 2;
            /**
             * 更新
             */
            int UPDATE = 3;
            /**
             * 查询
             */
            int SELECT = 4;
            /**
             * 上传
             */
            int UPLOAD = 5;
            /**
             * 下载
             */
            int DOWNLOAD = 6;
            /**
             * 导入
             */
            int IMPORT = 7;
            /**
             * 导出
             */
            int EXPORT = 8;
            /**
             * 登录
             */
            int LOGIN = 9;
            /**
             * 登出
             */
            int LOGOUT = 10;
            /**
             * 其他
             */
            int OTHER = 11;
            /**
             * 注册
             */
            int REGISTER = 12;
            /**
             * 找回密码
             */
            int FORGOT_PWD = 13;
            /**
             * 角色授权
             */
            int ROME_AUTH_MENU = 14;
        }
    }

    /**
     * 验证码
     */
    interface Captcha {
        /**
         * 类型
         */
        interface Type {
            /**
             * 动图
             */
            int GIF = 0;
            /**
             * 中文
             */
            int CHINESE = 1;
            /**
             * 中文动图
             */
            int CHINESE_GIF = 2;
            /**
             * 算术
             */
            int ARITHMETIC = 3;
            /**
             * 字符
             */
            int CHARACTER = 4;
        }

        interface FromType {
            /**
             * 从登录页面发送的验证码
             */
            Integer LOGIN = 1;
            /**
             * 从注册页面发送的验证码
             */
            Integer REGISTER = 2;
            /**
             * 从找回密码页面发送的验证码
             */
            Integer FORGOT_PWD = 3;
        }

        interface CachePrefix {
            /**
             * 来自登录的验证码请求缓存前缀
             */
            String LOGIN = "login-";
            /**
             * 来自注册的验证码请求缓存前缀
             */
            String REGISTER = "register-";
            /**
             * 来自忘记密码的验证码请求缓存前缀
             */
            String FORGOT_PWD = "forgotPwd-";
        }
    }

    interface User {
        interface Gender {
            /**
             * 男
             */
            Integer MAN = 1;
            /**
             * 女
             */
            Integer WOMAN = 0;
        }

        /**
         * 找回密码
         */
        interface ForgotPwd {
            /**
             * 找回密码方式
             */
            interface Method {
                /**
                 * 邮箱
                 */
                Integer EMAIL = 1;
                /**
                 * 手机短信
                 */
                Integer PHONE = 2;
            }
        }

        /**
         * 用户状态
         */
        interface Status {
            /**
             * 锁住
             */
            Integer LOCKED = 0;
            /**
             * 正常
             */
            Integer NORMAL = 1;
        }

        /**
         * 事件类型
         */
        interface EventType {
            /**
             * 添加操作
             */
            int ADD = 1;
            /**
             * 更新操作
             */
            int UPDATE = 2;
            /**
             * 删除操作
             */
            int DELETE = 3;
            /**
             * 禁用
             */
            int LOCKED = 4;
            /**
             * 禁用恢复正常
             */
            int UN_LOCK = 5;
            /**
             * 修改密码
             */
            int UPDATE_PWD = 6;
            /**
             * 导入
             */
            int IMPORT = 7;
        }

        /**
         * 账号是否已修改
         */
        interface UsernameUpdated {
            /**
             * 是
             */
            Integer YES = 1;
            /**
             * 否
             */
            Integer NO = 0;
        }
    }

    interface Org {
        /**
         * 根机构
         */
        String SUPER_PARENT_ID = "0";
        /**
         * 父节点信息分隔符
         */
        String SEPARATOR = ".";
    }

    interface Area {
        /**
         * 根区域ID
         */
        String SUPER_PARENT_ID = "0";
        /**
         * 父节点信息分隔符
         */
        String SEPARATOR = ".";

        /**
         * 区域类型
         */
        interface Type {
            /**
             * 国家
             */
            String COUNTRY = "1";

            /**
             * 省份直辖市
             */
            String PROVINCE = "2";

            /**
             * 地市
             */
            String MUNICIPAL = "3";

            /**
             * 区县
             */
            String DISTRICT_COUNTY = "4";

        }

        interface Status {
            /**
             * 有效
             */
            int NORMAL = 1;
            /**
             * 禁用
             */
            int FORBIDDEN = 0;
        }
    }

    interface Company {
        String SUPER_PARENT_ID = "0";
        /**
         * 父节点信息分隔符
         */
        String SEPARATOR = ".";
    }

    interface Menu {
        /**
         * 根菜单
         */
        String SUPER_PARENT_ID = "0";

        /**
         * 菜单打开方式
         */
        interface Target {
            /**
             * 默认。在相同的框架中打开被链接文档
             */
            String SELF = "_self";
            /**
             * 在新窗口中打开被链接文档
             */
            String BLANK = "_blank";
            /**
             * 在父框架集中打开被链接文档
             */
            String PARENT = "_parent";
            /**
             * 在整个窗口中打开被链接文档
             */
            String TOP = "_top";
        }

        /**
         * 菜单提醒文本来源
         */
        interface TipFrom {
            /**
             * SQL 脚本查询
             */
            int SQL = 1;
            /**
             * 通过springBean进行获取，该方法为getTip无入参，出参为字符串s
             */
            int SPRING_BEAN = 2;
            /**
             * 自定义内容
             */
            int CUSTOM = 3;
        }

        /**
         * 聚合路由
         */
        interface MergeRoute {
            /**
             * 否
             */
            int N = 0;
            /**
             * 是
             */
            int Y = 1;
        }

        /**
         * 类型
         */
        interface Type {
            /**
             * 目录
             */
            int CATALOG = 0;
            /**
             * 菜单
             */
            int MENU = 1;
            /**
             * 按钮
             */
            int BUTTON = 2;
            /**
             * 数据规则
             */
            int DATA_RULE = 3;
        }

        /**
         * 数据规则可用变量
         */
        interface RuleVar {
            /**
             * 当前用户变量的前缀
             */
            String CURRENT_USER_PREFIX = "currentUser.";
            /**
             * 所属行政机构和子机构
             */
            String ORG_AND_CHILDREN = "org_and_children";
            /**
             * 所属行政机构的子机构
             */
            String ORG_CHILDREN = "org_children";
            /**
             * 所属业务机构+行政机构
             */
            String BUSINESS_ORG_WITH_ADMIN_ORG = "business_org_with_admin_org";
            /**
             * 所属业务机构
             */
            String BUSINESS_ORG_WITHOUT_ADMIN_ORG = "business_org_without_admin_org";
        }

        /**
         * 规则条件
         */
        interface RuleCondition {
            /**
             * 大于
             */
            String GT = "gt";
            /**
             * 大于等于
             */
            String GE = "ge";
            /**
             * 小于
             */
            String LT = "lt";
            /**
             * 小于等于
             */
            String LE = "le";
            /**
             * 等于
             */
            String EQ = "eq";
            /**
             * 不等于
             */
            String NE = "ne";
            /**
             * 包含
             */
            String IN = "in";
            /**
             * 不包含
             */
            String NOT_IN = "not_in";
            /**
             * 模糊匹配
             */
            String LIKE = "like";
            /**
             * 左模糊
             */
            String LEFT_LIKE = "left_like";
            /**
             * 右模糊
             */
            String RIGHT_LIKE = "right_like";
            /**
             * 自定义SQL
             */
            String CUSTOM_SQL = "sql";
            /**
             * 不限制，就是不添加到where中
             */
            String ALL = "all";
            /**
             * groovy脚本动态生成待拼接的SQL
             */
            String GROOVY = "groovy";
        }
    }

    interface Role {
        /**
         * 超级管理员角色ID
         */
        String SUPER_ADMIN_ROLE_ID = "1";
        /**
         * 租户管理员角色ID
         */
        String TENANT_ADMIN_ROLE_ID = "2";
        /**
         * 默认所属ID
         */
        String DEFAULT_BELONG_ID = "sys";

        /**
         * 用户角色表中非机构角色默认的机构id
         */
        String DEFAULT_USER_ROLE_ORG_ID = "-1";

        /**
         * 操作数据规则的权限名，拥有改权限则允许为其他角色授予数据规则
         */
        String DATA_RULE_PERMISSION = "sys:auth:dataRule";

        /**
         * 类型
         */
        interface Type {
            /**
             * 系统角色，不允许通过程序进行修改
             */
            String SYS_ROLE = "1";
            /**
             * 业务角色，各个机构都能够看到
             */
            String BUSINESS_ROLE = "2";
            /**
             * 机构角色，从org_role迁移过来
             */
            String ORG_ROLE = "3";
        }

        /**
         * 所属类型、用于一对多
         */
        interface BelongType {
            /**
             * 属于系统，管理员通过角色管理创建的都是
             */
            String SYS = "1";
            /**
             * 属于机构
             */
            String ORG = "2";
        }

        /**
         * 系统角色编码
         */
        interface Code {
            /**
             * 超级管理员角色
             */
            String SUPER_ADMIN_ROLE = "superAdminRole";
            /**
             * 管理员角色
             */
            String MANAGER_ROLE = "managerRole";
        }

    }

    /**
     * 定时任务
     */
    interface Schedule {
        /**
         * 类型
         */
        interface Type {
            /**
             * javaBean、利用反射创建对象并执行
             */
            Integer JAVA_BEAN = 1;
            /**
             * springBean、利用反射执行
             */
            Integer SPRING_BEAN = 2;
            /**
             * 调用接口
             */
            Integer HTTP = 3;
            /**
             * 函数
             */
            Integer FUNCTION = 4;
        }

        /**
         * Http类型
         */
        interface HttpType {
            /**
             * 同步请求
             */
            Integer SYNC = 1;
            /**
             * 异步请求
             */
            Integer ASYNC = 2;
        }

        /**
         * http方法
         */
        interface HttpMethod {
            /**
             * GET请求
             */
            Integer GET = 1;
            /**
             * POST请求
             */
            Integer POST = 2;
        }

        /**
         * 状态
         */
        interface Status {
            /**
             * 正常
             */
            int NORMAL = 0;
            /**
             * 暂停
             */
            int PAUSE = 1;
        }
    }

    /**
     * 实体字段常量
     */
    interface EntityField {
        /**
         * 租户ID
         */
        String TENANT_ID = "tenantId";
        /**
         * 机构ID
         */
        String ORG_ID = "orgId";
        /**
         * 创建者
         */
        String CREATE_BY = "createBy";
        /**
         * 创建时间
         */
        String CREATE_DATE = "createDate";
        /**
         * 更新者
         */
        String UPDATE_BY = "updateBy";
        /**
         * 更新时间
         */
        String UPDATE_DATE = "updateDate";
    }

    /**
     * 数据库字段
     */
    interface ColumnField {
        /**
         * 主键
         */
        String ID = "id";
        /**
         * 租户ID
         */
        String TENANT_ID = "tenant_id";
        /**
         * 机构ID
         */
        String ORG_ID = "org_id";
        /**
         * 创建者
         */
        String CREATE_BY = "create_by";
        /**
         * 创建时间
         */
        String CREATE_DATE = "create_date";
        /**
         * 更新者
         */
        String UPDATE_BY = "update_by";
        /**
         * 更新时间
         */
        String UPDATE_DATE = "update_date";
    }

    /**
     * 登录
     */
    interface Login {
        /**
         * 默认终端类型
         */
        interface DefaultTerminal {
            /**
             * PC 电脑
             */
            String PC = "pc";
            /**
             * 安卓
             */
            String ANDROID = "android";
            /**
             * 苹果IOS
             */
            String IOS = "ios";
        }

        /**
         * 登录策略
         */
        enum LoginStrategy {
            /**
             * 多终端可以同时登录
             * 如：在多个浏览器登录同一个用户
             */
            MULTI_TERMINAL,
            /**
             * 只允许每次在一个终端进行登录，其他终端登录时会掉线最先登录的
             * 如：在多个浏览器最多只能打开一个，以最后一次登录为准
             */
            SINGLE_TERMINAL;
        }
    }

    /**
     * jwt
     */
    interface Jwt {
        /**
         * 用户ID
         */
        String USER_ID = "uid";
        /**
         * jwt的唯一标识
         */
        String ID = "id";
        /**
         * 账号
         */
        String USER_NAME = "uname";
        /**
         * 真实用户名
         */
        String REAL_NAME = "rname";
        /**
         * 租户ID
         */
        String TENANT_ID = "tid";
        /**
         * 机构ID
         */
        String ORG_ID = "oid";
        /**
         * 租户管理员
         */
        String TENANT_MANAGER = "tm";
        /**
         * 数据类型
         */
        String DATA_PERMISSION_TYPE = "dpType";

        /**
         * 存储策略
         */
        enum StoreStrategy {
            /**
             * 无状态存储
             */
            NONE,
            /**
             * 进程内存储，也叫单节点
             */
            PROCESS,
            /**
             * 分布式存储
             * Distributed
             */
            DIS;
        }

        interface AllowTakeMethod {
            /**
             * 允许通过cookie传递token
             */
            String COOKIES = "cookies";
            /**
             * 允许通过header传递token
             */
            String HEADER = "header";
            /**
             * 允许通过parameter传递token, 如：url?token=xxxx
             */
            String PARAMETER = "parameter";
        }
    }

    /**
     * 响应
     */
    interface Response {
        /**
         * 响应码
         */
        interface Code {
            /**
             * 未登录
             */
            int NO_LOGIN = 401;
            /**
             * 无权限
             */
            int NO_ACCESS = 403;
            /**
             * 资源不存在
             */
            int NO_FOUNT = 404;
            /**
             * 服务端异常
             */
            int SERVER_ERROR = 500;
            /**
             * 成功
             */
            int SUCCESS = 200;
        }

        interface Msg {
            /**
             * 没有传入token
             */
            String NO_TOKEN = "check if you set token in (header|cookie|path)";
            /**
             * 过期token
             */
            String EXPIRE_TOKEN = "token has expired";
            /**
             * 被其他人挤下线了
             */
            String OFF_LINE_TOKEN = "You're offline by others";
            /**
             * token非法，解密失败
             */
            String ILLEGAL_TOKEN = "illegal token";
        }
    }

    interface Category {
        interface Status {
            /**
             * 正常
             */
            int NORMAL = 0;
            /**
             * 禁用
             */
            int FORBIDDEN = 1;
        }

        String SEPARATOR = ".";

        String SUPER_PARENT_ID = "0";
        int DEFAULT_ORDER_NUM = 0;
    }

    interface Tenant {
        /**
         * 超级租户ID
         */
        String SUPER_TENANT_ID = "1";

        /**
         * 租户数据共享类型
         */
        interface ShareType {
            /**
             * 共享
             */
            Integer SHARE = 1;
            /**
             * 隔离
             */
            Integer ISOLATE = 2;
        }

        /**
         * 事件类型
         */
        interface EventType {
            /**
             * 添加操作
             */
            int ADD = 1;
            /**
             * 更新操作
             */
            int UPDATE = 2;
            /**
             * 删除操作
             */
            int DELETE = 3;
        }
    }

    interface Logger {
        interface Status {
            /**
             * 正常
             */
            int NORMAL = 0;
            /**
             * 禁用
             */
            int FORBIDDEN = 1;
        }
    }

    /**
     * 系统设置
     */
    interface Setting {

        interface Key {
            /**
             * 注册时需要的角色编码集合
             */
            String REGIST_ROLE_ID_LIST = "regist.role.id.list";
            /**
             * 注册时需要的机构ID集合
             */
            String REGIST_ORG_ID = "regist.org.id";

            Set<String> SYS_SETTING_KEY_SET = Sets.newHashSet(REGIST_ROLE_ID_LIST, REGIST_ORG_ID);
        }
    }

    /**
     * 公告状态
     */
    interface Notice {

        /**
         * 如果摘要为空的话，截取内容作为摘要的长度
         */
        int DIGEST_SUB = 54;

        String NOTICE_TYPE_DICT_CODE = "NOTICE_TYPE";

        interface Stick {
            /**
             * 置顶
             */
            int TOP = 1;
            /**
             * 默认（取消置顶）
             */
            int NORMAL = 0;
        }

        interface Status {
            /**
             * 已上线
             */
            int ONLINE = 0;
            /**
             * 已下线
             */
            int OFFLINE = 1;
            /**
             * 待上线
             */
            int STAY_ONLINE = 2;
            /**
             * 草稿
             */
            int DRAFT = 3;
        }

    }

    /**
     * 判重策略
     */
    enum RepeatStrategy {
        /**
         * 全局唯一
         */
        GLOBAL,
        /**
         * 租户下唯一
         */
        TENANT,
        /**
         * 用户下唯一
         */
        CREATE_BY,
        /**
         * 机构下唯一
         */
        ORG;
    }

    /**
     * 岗位
     */
    interface Post {

        /**
         * 类型
         */

        interface Type {
            /**
             * 高层
             */
            String HIGH = "1";
            /**
             * 中层
             */
            String MIDDLE = "2";
            /**
             * 基层
             */
            String BASIC = "3";
            /**
             * 其他
             */
            String OTHER = "4";
        }

        interface Status {
            /**
             * 有效
             */
            int NORMAL = 1;
            /**
             * 禁用
             */
            int FORBIDDEN = 0;
        }
    }

    /**
     * 模块
     */
    interface Module {

        interface Status {
            /**
             * 有效
             */
            int NORMAL = 1;
            /**
             * 禁用
             */
            int FORBIDDEN = 0;
        }
    }

    interface Audit {
        /**
         * 未初始化密码
         */
        String NOT_INIT_PWD = "1";
        /**
         * 未定期修改密码
         */
        String NOT_CHANGE_PWD = "2";
        /**
         * 长期未登录
         */
        String LONG_TIME_NO_LOGIN = "3";
        /**
         * 密码即将过期
         */
        String PWD_WILL_EXPIRE = "4";
        /**
         * 密码已过期
         */
        String PWD_EXPIRE = "5";
        /**
         * 未绑定手机
         */
        String NO_PHONE = "6";
        /**
         * 未绑定邮箱
         */
        String NO_EMAIL = "7";
        /**
         * 账号异常
         */
        String ACCOUNT_ABNORMAL = "8";
        /**
         * 分隔符
         */
        String SEPARATOR = " | ";
    }
}
