package com.gccloud.starter.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.hibernate.validator.constraints.Length;

import javax.validation.constraints.NotBlank;

/**
 * @author liuchengbiao
 * @date 2020-06-17 19:22
 */
@Data
@ApiModel
public class RepeatDTO {
    /**
     * ID 的值
     */
    @ApiModelProperty(notes = "对象的ID值，新增时查重可以不传入")
    private String id;
    /**
     * 字段名称
     */
    @ApiModelProperty(notes = "对象的属性名", required = true)
    @NotBlank(message = "查重的属性名不能为空")
    @Length(min = 1, max = 250, message = "查重的属性字段名长度必须在1~250之间")
    private String name;
    /**
     * 字段值
     */
    @ApiModelProperty(notes = "对象的属性值", required = true)
    @NotBlank(message = "查重的属性值不能为空")
    @Length(min = 1, max = 250, message = "查重的属性值长度必须在1~250之间")
    private String value;

    /**
     * 租户id
     */
    @ApiModelProperty(notes = "租户id")
    private String tenantId;
}
