package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 第三方应用api接入;
 * 用于第三方不需要使用用户名密码进行登录；
 */
@Data
@TableName("gc_api_app")
@ApiModel
@ToString(callSuper = true)
public class SysApiAppEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "应用名称")
    private String name;

    @ApiModelProperty(notes = "应用编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;
    /**
     * 保证唯一，能够找到应用就行
     */
    @ApiModelProperty(notes = "应用key")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String appKey;
    /**
     * 用于客户端继续加密；服务端进行校验使用
     */
    @ApiModelProperty(notes = "应用秘钥")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String appSecret;

    /**
     * 验证成功后颁发代理用户的token
     */
    @ApiModelProperty(notes = "代理用户")
    private String proxyUserId;

    @ApiModelProperty(notes = "备注")
    private String remark;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 用户所属机构id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属机构ID")
    private String orgId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;

}
