package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 区域
 */
@Data
@TableName("gc_area")
@ApiModel
@ToString(callSuper = true)
public class SysAreaEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "区域名称")
    private String name;

    @ApiModelProperty(notes = "区域编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;
    /**
     * 便于项目中做映射关系
     */
    @ApiModelProperty(notes = "区域业务编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String bizCode;

    @ApiModelProperty(notes = "区域类型(国家、省份直辖市、地市、区县)")
    private String type;

    @ApiModelProperty(notes = "上级区域ID")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String parentId;

    /**
     * 参考 {@link GlobalConst.Area.SEPARATOR}
     */
    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    @ApiModelProperty(notes = "区域ID序列,多个之间使用分隔符隔开")
    private String ids;

    @ApiModelProperty(notes = "区域名称序列,多个之间使用分隔符隔开")
    private String names;

    @ApiModelProperty(notes = "区域编码序列,多个之间使用分隔符隔开")
    private String codes;

    @ApiModelProperty(notes = "区域业务编码序列,多个之间使用分隔符隔开")
    private String bizCodes;

    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点（0： 没有; 非零：有）")
    private Integer hasChildren;

    @ApiModelProperty(notes = "排序号")
    private Integer orderNum = 999;

    @ApiModelProperty(notes = "备注")
    private String remark;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 用户所属机构id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属机构ID")
    private String orgId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;

}
