package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 分类字典
 * </p>
 *
 * @author MaoShufeng
 * @since 2020-06-11
 */
@Data
@Accessors(chain = true)
@TableName("gc_category")
@ApiModel
@ToString(callSuper = true)
public class SysCategoryEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "父字典树id")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String parentId;

    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    @ApiModelProperty(notes = "所有直接父节点的ID集合，多个之间使用逗号隔开", hidden = true)
    private String ids;

    @ApiModelProperty(notes = "字典树名称")
    private String name;

    @ApiModelProperty(notes = "字典树编码")
    private String code;
    /**
     * 参考 {@link GlobalConst.Category.Status}
     */
    @ApiModelProperty(notes = "状态")
    private Integer status;
    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点（0： 没有; 1：有）")
    private Integer hasChildren;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;

    @ApiModelProperty(notes = "备注")
    private String remark;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 用户所属机构id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属机构ID")
    private String orgId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
