package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.Date;

/**
 * 公司
 */
@Data
@TableName("gc_company")
@ApiModel
@ToString(callSuper = true)
public class SysCompanyEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "公司名称")
    private String name;

    @ApiModelProperty(notes = "公司全称")
    private String fullName;

    @ApiModelProperty(notes = "公司编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;

    @ApiModelProperty(notes = "区域ID")
    private String areaId = "0";

    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点")
    private Boolean hasChildren;

    @ApiModelProperty(notes = "父公司ID")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String parentId;

    /**
     * 参考 {@link GlobalConst.Company.SEPARATOR}
     */
    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    @ApiModelProperty(notes = "公司ID集合，多个之间使用分隔符隔开")
    private String ids;

    /**
     * 参考 {@link GlobalConst.Company.SEPARATOR}
     */
    @ApiModelProperty(notes = "公司名称序列,多个之间使用分隔符隔开")
    private String names;

    /**
     * 参考 {@link GlobalConst.Company.SEPARATOR}
     */
    @ApiModelProperty(notes = "公司编码序列,多个之间使用分隔符隔开")
    private String codes;

    @ApiModelProperty(notes = "排序号(升序)")
    private Integer orderNum;

    @ApiModelProperty(notes = "备注")
    private String remark;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
