package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 业务字典项
 * </p>
 *
 * @author MaoShufeng
 * @since 2020-06-11
 */
@Data
@Accessors(chain = true)
@TableName("gc_dict_item")
@ApiModel
@NoArgsConstructor
@ToString(callSuper = true)
public class SysDictItemEntity implements Serializable {

    public SysDictItemEntity(String dictCode, String name, String value, String remark, Integer orderNum, Integer status) {
        this.dictCode = dictCode;
        this.name = name;
        this.value = value;
        this.remark = remark;
        this.orderNum = orderNum;
        this.status = status;
    }


    private static final long serialVersionUID = 1L;

    @ApiModelProperty(notes = "业务字典编码")
    private String dictCode;

    @ApiModelProperty(notes = "业务字典项名称")
    private String name;

    @ApiModelProperty(notes = "业务字典项值")
    private String value;

    @ApiModelProperty(notes = "业务字典描述")
    private String remark;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    /**
     * 参考 {@link GlobalConst.DictItem.Status}
     */
    @ApiModelProperty(notes = "状态")
    private Integer status;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 用户所属机构id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属机构ID")
    private String orgId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;

}
