package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 文件
 */
@Data
@Accessors(chain = true)
@TableName("gc_file")
@ApiModel
@ToString(callSuper = true)
public class SysFileEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "业务所属模块，从业务字典FILE_MODULE获取值")
    private String module;

    @ApiModelProperty(notes = "原文件名")
    private String originalName;

    @ApiModelProperty(notes = "新文件名")
    private String newName;

    @ApiModelProperty(notes = "后缀名(如: txt、png、doc、java等)")
    private String extension;

    @ApiModelProperty(notes = "路径")
    private String path;

    @ApiModelProperty(notes = "访问地址")
    private String url;

    @ApiModelProperty(notes = "文件大小")
    private Long size;

    @ApiModelProperty(notes = "下载次数")
    private Integer downloadCount = 0;

    @ApiModelProperty(notes = "上传用户")
    private String userName;

    @ApiModelProperty(notes = "桶名")
    private String bucket;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
