package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author MaoShufeng
 * @since 2020-06-11
 */
@Data
@Accessors(chain = true)
@TableName("gc_log")
@ApiModel
@ToString(callSuper = true)
public class SysLogEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 参考 {@link GlobalConst.Log.Type}
     * 可以后面进行扩展
     */
    @ApiModelProperty(notes = "日志类型")
    private Integer type;

    /**
     * 参考 {@link GlobalConst.Log.State}
     * 可以后面进行扩展
     */
    @ApiModelProperty(notes = "日志状态")
    private Integer state = GlobalConst.Log.State.NORMAL;

    @ApiModelProperty(notes = "用户名")
    private String username;

    @ApiModelProperty(notes = "用户昵称")
    private String realName;
    /**
     * 操作的模块名、如用户管理模块
     */
    @ApiModelProperty(notes = "模块名")
    private String module;

    @ApiModelProperty(notes = "操作")
    private String operation;

    @ApiModelProperty(notes = "调用方法")
    private String method;

    @ApiModelProperty(notes = "客户端IP")
    private String clientIp;

    @ApiModelProperty(notes = "设备名称")
    private String deviceName;

    @ApiModelProperty(notes = "浏览器名称")
    private String browserName;

    @ApiModelProperty(notes = "用户代理")
    private String userAgent;

    @ApiModelProperty(notes = "请求地址")
    private String requestUri;

    @ApiModelProperty(notes = "请求方法")
    private String requestMethod;

    @ApiModelProperty(notes = "查询条件,在?后面的参数")
    private String queryString;

    @ApiModelProperty(notes = "异常信息")
    private String exception = "";

    @ApiModelProperty(notes = "请求参数")
    private String params = "";

    @ApiModelProperty(notes = "耗时")
    private Long elapsedTime;

    @ApiModelProperty(notes = "创建用户ID")
    @TableField(fill = FieldFill.INSERT)
    private String createBy;

    @ApiModelProperty(notes = "机构ID")
    @TableField(fill = FieldFill.INSERT)
    private String orgId;

    @ApiModelProperty(notes = "创建时间")
    @TableField(fill = FieldFill.INSERT)
    private Date createDate;
}
