package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.mybatis.typeHandler.ExtendObjJsonTypeHandler;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 菜单实体
 */
@Data
@Accessors(chain = true)
@TableName(value = "gc_menu", autoResultMap = true)
@ApiModel
@ToString(callSuper = true)
public class SysMenuEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;
    @ApiModelProperty(notes = "父id")
    private String parentId;
    @ApiModelProperty(notes = "菜单/数据规则名称")
    private String name;
    @ApiModelProperty(notes = "是否有子节点")
    private Boolean hasChildren;
    @ApiModelProperty(notes = "访问地址")
    private String path;
    /**
     * 参考 {@link GlobalConst.Menu.Type}
     */
    @TableField(updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "菜单类型,类型 0：目录 1：菜单 2：按钮")
    private Integer type;
    /**
     * 是否是聚合路由
     * 参考 {@link GlobalConst.Menu.MergeRoute}
     */
    private Integer mergeRoute;
    @ApiModelProperty(notes = "菜单编码")
    private String code;
    @ApiModelProperty(notes = "组件地址")
    private String component;
    @ApiModelProperty(notes = "外链地址(支持表达式，格式为${xxx})")
    private String iframeUrl;
    @ApiModelProperty(notes = "首页设置(不设置系统自动解析)")
    private Boolean home;
    @ApiModelProperty(notes = "顶部显示(特定布局生效)")
    private Boolean top;
    @ApiModelProperty(notes = "菜单参数")
    @TableField(typeHandler = ExtendObjJsonTypeHandler.class)
    private ExtendObj params;
    @ApiModelProperty(notes = "授权(多个用逗号分隔，如：user:list,user:create)")
    private String permissions;
    @ApiModelProperty(notes = "菜单或目录图标")
    private String icon;
    @ApiModelProperty(notes = "文本提醒是否启用")
    private Boolean tipDisabled;
    /**
     * 文本提醒的内容来源，支持SQL、java bean、固定值
     * 参考{@link GlobalConst.Menu.TipFrom}
     */
    @ApiModelProperty(notes = "文本提醒信息来源")
    private Integer tipFrom;
    /**
     * 用于在菜单的右侧显示的提醒文本
     */
    @ApiModelProperty(notes = "文本提醒来源脚本")
    private String tipScript;
    @TableField(exist = false)
    @ApiModelProperty(notes = "文本提醒")
    private String tipContent;
    /**
     * 参考 {@link GlobalConst.Menu.Target}
     */
    @ApiModelProperty(notes = "菜单打开方式")
    private String target;
    @ApiModelProperty(notes = "是否缓存（1：缓存; 0:不缓存）")
    private Boolean keepAlive;
    @ApiModelProperty(notes = "菜单是否隐藏(1: 隐藏; 0: 显示)")
    private Boolean hide;
    @ApiModelProperty(notes = "是否禁用(1: 禁用,0: 正常)")
    private Boolean disabled;
    @ApiModelProperty(notes = "包裹组件地址")
    private String wrapComponent;
    @ApiModelProperty(notes = "菜单排序")
    private Integer orderNum = 999;
    // 数据规则属性
    @ApiModelProperty(notes = "规则编码")
    private String ruleCode;
    @ApiModelProperty(notes = "规则字段")
    private String ruleColumn;
    /**
     * 参考 {@link GlobalConst.Menu.RuleCondition}
     */
    @ApiModelProperty(notes = "规则条件")
    private String ruleCondition;
    @ApiModelProperty(notes = "规则值")
    private String ruleValue;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户id")
    private String tenantId;
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;
    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;
    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;
    @ApiModelProperty(notes = "菜单说明")
    private String remark;
    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
