package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * @Author zhangtaozhir
 * @Description 模块
 * @Date 16:06 2022/1/15
 * @Param
 * @return
 **/
@Data
@Accessors(chain = true)
@TableName("gc_module")
@ApiModel
@ToString(callSuper = true)
public class SysModuleEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;

    @ApiModelProperty(notes = "模块名称")
    private String moduleName;

    @ApiModelProperty(notes = "是否使用，0禁用，1启用")
    private Integer status;

    @ApiModelProperty(notes = "备注")
    private String remark;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    /**
     * 用户所属机构id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属机构ID")
    private String orgId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
