package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.extend.field.entity.SysNoticeEntityExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * @author renxx
 * @data 2021/9/6 15:44
 */
@Data
@Accessors(chain = true)
@TableName("gc_notice")
@ApiModel
@ToString(callSuper = true)
public class SysNoticeEntity extends SysNoticeEntityExtend implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(value = "公告标题")
    private String title;

    @ApiModelProperty(value = "发布者名")
    private String publisher;

    @ApiModelProperty(value = "公告类型")
    @NotBlank(message = "公告栏目不能为空", groups = {Insert.class, Update.class})
    private String type;

    @ApiModelProperty(value = "摘要")
    private String digest;

    @ApiModelProperty(value = "公告内容")
    private String content;

    /**
     * 参考 {@link GlobalConst.Notice.Stick}
     */
    @ApiModelProperty(value = "0:默认,不置顶，1：置顶")
    private Integer stickTop;

    @ApiModelProperty(value = "附件名")
    private String attachment;

    /**
     * 参考 {@link GlobalConst.Notice.Status}
     */
    @NotBlank(message = "公告状态不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(value = "公告状态,0在线，1草稿，2下线")
    private Integer status;

    @JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "发布时间")
    private Date startDate;

    @JsonFormat(shape= JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty(value = "失效时间")
    private Date endDate;

    @ApiModelProperty(value = "阅读次数")
    private Integer readNum;

    @ApiModelProperty(value = "回复数")
    private Integer replyNum;

    @ApiModelProperty(value = "回复启用标识,1开启，0关闭")
    private Integer replyEnable;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;

}
