package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.extend.field.entity.SysOrgEntityExtend;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 机构实体
 */
@Data
@Accessors(chain = true)
@TableName(value = "gc_org", autoResultMap = true)
@ApiModel
@ToString(callSuper = true)
public class SysOrgEntity extends SysOrgEntityExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "机构名称")
    private String name;

    @ApiModelProperty(notes = "机构全名")
    private String fullName;

    @ApiModelProperty(notes = "机构编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;

    @ApiModelProperty(notes = "机构类型(如：市级公司、省级公司、部门等)")
    private String type;

    @ApiModelProperty(notes = "父机构ID")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String parentId;
    /**
     * 父机构ID集合，多个之间使用逗号隔开
     */
    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    @ApiModelProperty(notes = "父机构ID集合，多个之间使用逗号隔开")
    private String ids;

    @ApiModelProperty(notes = "父机构名称集合，多个之间使用逗号隔开")
    private String names;

    @ApiModelProperty(notes = "父机构编码集合，多个之间使用逗号隔开")
    private String codes;

    @ApiModelProperty(notes = "是否有子节点")
    private Boolean hasChildren;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;

    @ApiModelProperty(notes = "负责人")
    private String principal;

    @ApiModelProperty(notes = "联系方式")
    private String contact;

    @ApiModelProperty(notes = "联系地址")
    private String address;

    @ApiModelProperty(notes = "邮政编码")
    private String zipCode;

    @ApiModelProperty(notes = "电子邮箱")
    private String email;

    @ApiModelProperty(notes = "备注")
    private String remark;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "租户id")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.UPDATE, insertStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
