package com.gccloud.starter.common.entity;

import java.util.Date;
import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.extend.field.entity.SysPostEntityExtend;
import lombok.Data;
import java.io.Serializable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
/**
* 岗位表
* @Author qianxing
* @Date 2021/09/09
* @Version 1.0.0
*/
@Data
@TableName("gc_post")
@ApiModel
public class SysPostEntity extends SysPostEntityExtend implements Serializable{

    private static final long serialVersionUID = 1L;

    @TableId
	
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "岗位名称")
    private String name;
	
    @ApiModelProperty(notes = "岗位编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;

    @ApiModelProperty(notes = "岗位类型")
    private String type;

    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
	
    @ApiModelProperty(notes = "备注")
    private String remark;

    @ApiModelProperty(notes = "0为禁用，1为有效")
    private Integer status;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "租户id")
    private String tenantId;
    
	@TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建者")
    private String createBy;
    
	@TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;
    
	@TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新者")
    private String updateBy;
    
	@TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;
    
	
    @ApiModelProperty(notes = "删除标记0:保留,1:删除")
	@TableLogic(delval = "1", value = "0")
    private Integer delFlag;

}
