package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.mybatis.typeHandler.ExtendObjJsonTypeHandler;
import com.gccloud.starter.extend.field.entity.SysRoleEntityExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

import static com.gccloud.starter.common.constant.GlobalConst.Role;

/**
 * 角色实体
 */
@Data
@Accessors(chain = true)
@TableName(value = "gc_role", autoResultMap = true)
@ApiModel
@ToString(callSuper = true)
public class SysRoleEntity extends SysRoleEntityExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "角色名称")
    @NotBlank(message = "角色名不能为空", groups = {Insert.class, Update.class})
    private String name;

    @ApiModelProperty(notes = "角色编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String code;

    /**
     * 参考 {@link Role.Type}
     */
    @ApiModelProperty(notes = "角色类型")
    @NotBlank(message = "角色类型不能为空", groups = {Insert.class, Update.class})
    private String type;
    /**
     * 用户拥有的最大角色权重给其他角色赋予权限时 无权限赋予更大权限给其他人
     */
    @ApiModelProperty(notes = "权重(权重越大，权限越大)")
    private Integer weight;

    @ApiModelProperty(notes = "角色排序")
    private Integer orderNum;

    @ApiModelProperty(notes = "备注")
    private String remark;

    @ApiModelProperty(notes = "模块编码")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String moduleCode;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属机构id")
    private String orgId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属租户id")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;

    @ApiModelProperty(notes = "预留字段，建议存储json格式")
    @TableField(typeHandler = ExtendObjJsonTypeHandler.class)
    private ExtendObj extendObj;
}
