package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 *
 * </p>
 *
 * @author MaoShufeng
 * @since 2020-06-11
 */
@Data
@Accessors(chain = true)
@TableName("gc_tenant")
@ApiModel
@ToString(callSuper = true)
public class SysTenantEntity implements Serializable {

    private static final long serialVersionUID = 1L;
    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "租户名称")
    @NotBlank(message = "租户名不能为空", groups = {Insert.class, Update.class})
    private String name;


    @ApiModelProperty(notes = "租户编码")
    private String code;

    @ApiModelProperty(notes = "状态(0: 禁用, 1: 正常)")
    private Integer status;

    @ApiModelProperty(notes = "备注")
    private String remark;

    @ApiModelProperty(notes = "是否默认租户")
    private Boolean defaultTenant;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
