package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.extend.field.entity.SysUserEntityExtend;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;

/**
 * 用户实体
 */
@Data
@Accessors(chain = true)
@TableName(value = "gc_user", autoResultMap = true)
@ApiModel
@ToString(callSuper = true)
public class SysUserEntity extends SysUserEntityExtend implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "权重(权重越大，排名越靠前)")
    private Integer weight;

    @ApiModelProperty(notes = "员工工号")
    private String jobNumber;

    @NotBlank(message = "账户不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "账号")
    private String username;

    @ApiModelProperty(notes = "真实姓名")
    private String realName;

    @ApiModelProperty(notes = "用户昵称")
    private String nickname;

    /**
     * 参考 {@link GlobalConst.User.Status}
     */
    @ApiModelProperty(notes = "用户状态，1表示正常，0表示禁用")
    private Integer status;

    @ApiModelProperty(notes = "身份证号")
    private String idCard;

    @ApiModelProperty(notes = "头像存储路径")
    private String avatar;

    @ApiModelProperty(notes = "性别,0表示女性，1表示男性")
    private Integer gender;

    @ApiModelProperty(notes = "用户邮箱")
    private String email;

    @ApiModelProperty(notes = "手机号码")
    private String phone;

    @ApiModelProperty(notes = "办公电话")
    private String officeTel;

    @ApiModelProperty(notes = "QQ")
    private String qq;

    @ApiModelProperty(notes = "微信")
    private String wx;

    @ApiModelProperty(notes = "工作单位")
    private String company;

    @ApiModelProperty(notes = "工作职责")
    private String responsibility;

    @ApiModelProperty(notes = "个人地址")
    private String address;

    @TableField(updateStrategy = FieldStrategy.NOT_EMPTY)
    @NotBlank(message = "密码不能为空", groups = {Insert.class})
    @ApiModelProperty(notes = "密码")
    private String password;

    @ApiModelProperty(notes = "密码过期时间")
    private Date pwdExpireDate;

    /**
     * 用于定期提醒那些没有修改密码的人
     */
    @ApiModelProperty(notes = "最后密码修改时间")
    private Date lastPwdUpdateDate;
    /**
     * 用户分析用户登录的一个状态
     */
    @ApiModelProperty(notes = "最后登录时间")
    private Date lastLoginDate;

    @TableField(exist = false)
    @ApiModelProperty(notes = "第一次密码错误时间")
    private Date firstPwdErrorDate;

    @TableField(exist = false)
    @ApiModelProperty(notes = "密码错误次数")
    private Integer pwdErrorNum;

    @ApiModelProperty(notes = "最后登录IP")
    private String lastLoginIp;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "归属公司ID")
    private String companyId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "行政机构ID")
    private String orgId;

    /**
     * 参考{@link GlobalConst.User.UsernameUpdated}
     */
    @ApiModelProperty(notes = "账户是否能修改")
    private Integer usernameUpdated;

    /**
     * 用户所属租户id
     */
    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT, updateStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE, insertStrategy = FieldStrategy.NEVER)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = GlobalConst.DelFlag.DELETE + "", value = GlobalConst.DelFlag.NOAMAL + "")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
