package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.baomidou.mybatisplus.annotation.TableName;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 用户和机构之间关联
 */
@Data
@Accessors(chain = true)
@TableName("gc_user_org")
@ApiModel
@ToString(callSuper = true)
public class SysUserOrgEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "用户id")
    private String userId;

    @ApiModelProperty(notes = "附属机构ID")
    private String orgId;

    /**
     * 参考 {@link GlobalConst.UserOrg.Type}
     */
    @ApiModelProperty(notes = "关联类型")
    private String type;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
