package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * <p>
 * 用户和角色关联
 * </p>
 *
 * @author MaoShufeng
 * @since 2020-06-11
 */
@Data
@Accessors(chain = true)
@TableName("gc_user_role")
@ApiModel
@ToString(callSuper = true)
public class SysUserRoleEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "用户id")
    private String userId;

    @ApiModelProperty(notes = "角色id")
    private String roleId;

    /**
     * 仅用于保存机构角色时使用，非机构角色保存-1
     */
    @ApiModelProperty(notes = "机构id")
    private String orgId;

    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属租户ID")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
