package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.*;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 角色组和用户
 */
@Data
@Accessors(chain = true)
@TableName(value = "gc_user_role_group_map", autoResultMap = true)
@ApiModel
@ToString(callSuper = true)
public class SysUserRoleGroupMapEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "用户ID")
    @TableField(updateStrategy = FieldStrategy.NEVER)
    private String userId;

    @ApiModelProperty(notes = "角色组ID")
    private String roleGroupId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "所属租户id")
    private String tenantId;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建用户ID")
    private String createBy;

    @TableField(fill = FieldFill.INSERT)
    @ApiModelProperty(notes = "创建时间")
    private Date createDate;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新用户ID")
    private String updateBy;

    @TableField(fill = FieldFill.INSERT_UPDATE)
    @ApiModelProperty(notes = "更新时间")
    private Date updateDate;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
