package com.gccloud.starter.common.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;
import lombok.experimental.Accessors;

import java.io.Serializable;

/**
 * 用户和租户关联
 */
@Data
@Accessors(chain = true)
//@TableName("gc_user_tenant_map")
@ApiModel
@ToString(callSuper = true)
public class SysUserTenantMapEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * id 主键
     */
    @TableId
    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "用户id")
    private String userId;

    @ApiModelProperty(notes = "所属机构ID")
    private String tenantId;

    @TableLogic(delval = "1", value = "0")
    @ApiModelProperty(notes = "删除标识(0：正常，1：删除)", hidden = true)
    private Integer delFlag = 0;
}
