package com.gccloud.starter.common.init;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.config.GlobalConfig;
import com.gccloud.starter.common.config.bean.Jwt;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * jwt密钥检查
 *
 * @author liuchengbiao
 * @date 2020年12月22日13:42:08
 */
@Slf4j
@Component
@Order(10)
@ConditionalOnProperty(prefix = "gc.starter.component", name = "JwtSecretCheckCommandLineRunner", havingValue = "JwtSecretCheckCommandLineRunner", matchIfMissing = true)
public class JwtSecretCheckCommandLineRunner implements CommandLineRunner {

    @Resource
    private GlobalConfig config;

    @Override
    public void run(String... args) throws Exception {
        log.info(GlobalConst.Console.LINE);
        log.info("启动jwt安全秘钥检查");
        log.info(GlobalConst.Console.LINE);
        Jwt jwt = config.getJwt();
        if (jwt == null) {
            return;
        }
        String secret = jwt.getSecret();
        if (StringUtils.equals(secret, "GsT@2020")) {
            log.warn(GlobalConst.Console.LINE);
            for (int i = 1; i <= 3; i++) {
                log.error("警告{}次 您好，为了保证项目的安全，请您不要使用默认的jwt密钥，请自己换一个其他的吧", i);
            }
            log.warn(GlobalConst.Console.LINE);
        }
    }
}
