package com.gccloud.starter.common.init;

import com.gccloud.starter.common.constant.GlobalConst;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.io.IOUtils;
import org.springframework.boot.CommandLineRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.stereotype.Component;

import java.net.InetAddress;
import java.util.List;

/**
 * 启动时打印LOGO
 *
 * @author liuchengbiao
 * @date 2020-06-23 10:52
 */
@Slf4j
@Order(1)
@Component
@ConditionalOnProperty(prefix = "gc.starter.component", name = "SuccessCommandLineRunner", havingValue = "SuccessCommandLineRunner", matchIfMissing = true)
public class SuccessCommandLineRunner implements CommandLineRunner {

    @javax.annotation.Resource
    ResourceLoader resourceLoader;
    @javax.annotation.Resource
    private Environment env;

    @Override
    public void run(String... args) throws Exception {
        try {
            // 读取启动成功标识
            Resource resource = resourceLoader.getResource("classpath:success.txt");
            List<String> successLineList = IOUtils.readLines(resource.getInputStream());
            for (String line : successLineList) {
                System.out.println(line);
            }
        } catch (Exception e) {
            System.out.println("启动成功，如果您想自定义启动成功标识，您可以在工程src/resources下创建success.txt文件，并写入启动成功输出的信息");
        }
        String ip = InetAddress.getLocalHost().getHostAddress();
        String port = env.getProperty("server.port", "8080");
        String path = env.getProperty("server.servlet.context-path", "/");
        System.out.println("\n");
        System.out.println(String.format("本地服务地址: http://localhost:%s%s", port, path));
        System.out.println(String.format("本地服务地址: http://127.0.0.1:%s%s", port, path));
        System.out.println(String.format("生产服务地址: http://%s:%s%s", ip, port, path));
        System.out.println(String.format("Swagger接口文档地址: http://%s:%s%s/doc.html", ip, port, path));
        try {
            // 读取版本号
            Resource resource = resourceLoader.getResource("classpath:StarterVersion");
            List<String> lines = IOUtils.readLines(resource.getInputStream());
            if (lines != null && lines.size() > 0) {
                System.out.println(String.format("千行开发框架版本: %s", lines.get(0)));
            }
        } catch (Exception e) {
        }
        System.out.println(GlobalConst.Console.LINE);
    }

}
