package com.gccloud.starter.common.module.area.dto;

import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.area.BizCode;
import com.gccloud.starter.common.validator.module.area.Code;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@Data
public class SysAreaDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "区域名称")
    @NotBlank(message = "区域名称不能为空", groups = {Insert.class, Update.class})
    private String name;
    @ApiModelProperty(notes = "区域编码")
    @Code(message = "{gc.starter.validator.area.code.message}", groups = {Insert.class, Update.class})
    @NotBlank(message = "区域编码不能为空", groups = {Insert.class, Update.class})
    private String code;
    @ApiModelProperty(notes = "区域业务编码")
    @BizCode(message = "{gc.starter.validator.area.code.message}", groups = {Insert.class, Update.class})
    @NotBlank(message = "区域业务编码不能为空", groups = {Insert.class, Update.class})
    private String bizCode;
    @ApiModelProperty(notes = "区域类型")
    @NotBlank(message = "区域类型不能为空", groups = {Insert.class, Update.class})
    private String type;
    @ApiModelProperty(notes = "上级区域ID")
    @NotBlank(message = "上级区域不能为空", groups = {Insert.class, Update.class})
    private String parentId;
    @ApiModelProperty(notes = "排序号")
    private Integer orderNum = 999;
    @ApiModelProperty(notes = "备注")
    private String remark;
}