package com.gccloud.starter.common.module.area.vo;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.vo.TreeVo;
import com.gccloud.starter.extend.field.vo.SysAreaVOExtend;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class SysAreaVO extends SysAreaVOExtend implements TreeVo<SysAreaVO>, Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "区域名称")
    private String name;
    @ApiModelProperty(notes = "区域编码")
    private String code;
    @ApiModelProperty(notes = "区域业务编码")
    private String bizCode;
    @ApiModelProperty(notes = "区域类型")
    private String type;
    @ApiModelProperty(notes = "上级区域ID")
    private String parentId;
    @ApiModelProperty(notes = "上级区域名称")
    private String parentName;
    @ApiModelProperty(notes = "子区域集合")
    private List<SysAreaVO> children;
    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点（0： 没有; 非零：有）")
    private Integer hasChildren;
    @ApiModelProperty(notes = "排序号")
    private Integer orderNum = 999;
    @ApiModelProperty(notes = "备注")
    private String remark;
}