package com.gccloud.starter.common.module.category.dto;

import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.category.Code;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 分类字典
 *
 * @Author maoshufeng
 * @Date 2020-07-08
 * @Version 1.0.0
 */
@Data
@ToString(callSuper = true)
public class SysCategoryDTO implements Serializable {
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "字典名称")
    @NotBlank(message = "字典名称不能为空", groups = {Insert.class, Update.class})
    private String name;
    @ApiModelProperty(notes = "字典编码")
    @NotBlank(message = "字典编码不能为空", groups = {Insert.class, Update.class})
    @Code(message = "{gc.starter.validator.category.code.message}", groups = {Insert.class, Update.class})
    private String code;
    @ApiModelProperty(notes = "父字典树id")
    private String parentId;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum = 1000;
    @ApiModelProperty(notes = "备注")
    private String remark;
    @ApiModelProperty(notes = "字典状态")
    @NotNull(message = "字典状态不能为空", groups = {Insert.class, Update.class})
    private Integer status;
}
