package com.gccloud.starter.common.module.category.vo;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.vo.TreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Author maoshufeng
 * @Date 2020-06-18
 * @Version 1.0.0
 */
@ApiModel
@Data
@ToString(callSuper = true)
public class SysCategoryVO implements TreeVo<SysCategoryVO>, Serializable {
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "父字典树ID")
    private String parentId;
    @ApiModelProperty(notes = "父字典名称")
    private String parentName;
    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点（0： 没有; 1：有）")
    private Boolean hasChildren;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "备注")
    private String remark;
    @ApiModelProperty(notes = "状态")
    private Integer status;
    @ApiModelProperty(notes = "字典树名称")
    private String name;
    @ApiModelProperty(notes = "字典树编码")
    private String code;
    @ApiModelProperty(notes = "子字典集合")
    private List<SysCategoryVO> children;
}
