package com.gccloud.starter.common.module.company.dto;

import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.company.Code;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 公司管理
 */
@ApiModel
@Data
public class SysCompanyDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "公司名称")
    @NotBlank(message = "公司名称不能为空", groups = {Insert.class, Update.class})
    private String name;
    @ApiModelProperty(notes = "公司全称")
    @NotBlank(message = "公司全称不能为空", groups = {Insert.class, Update.class})
    private String fullName;
    @ApiModelProperty(notes = "公司编码")
    @Code(message = "{gc.starter.validator.company.code.message}", groups = {Insert.class, Update.class})
    @NotBlank(message = "公司编码不能为空", groups = {Insert.class, Update.class})
    private String code;
    @ApiModelProperty(notes = "区域ID")
    private String areaId;
    @ApiModelProperty(notes = "父公司ID")
    @NotBlank(message = "父公司不能为空", groups = {Insert.class, Update.class})
    private String parentId;
    @ApiModelProperty(notes = "排序号(升序)")
    private Integer orderNum = 1000;
    @ApiModelProperty(notes = "备注")
    private String remark;
}
