package com.gccloud.starter.common.module.company.vo;

import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 公司VO，返回给API调用方
 */
@ApiModel
@Data
public class SysCompanyVO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "公司名称")
    private String name;
    @ApiModelProperty(notes = "公司全称")
    private String fullName;
    @ApiModelProperty(notes = "公司编码")
    private String code;
    /**
     * 参考 {@link GlobalConst.HasChildren}
     */
    @ApiModelProperty(notes = "是否有子节点")
    private Boolean hasChildren;
    @ApiModelProperty(notes = "父公司ID")
    private String parentId;
    @ApiModelProperty(notes = "父公司名称")
    private String parentName;
    @ApiModelProperty(notes = "公司ID集合，多个之间使用分隔符隔开")
    private String ids;
    @ApiModelProperty(notes = "公司名称序列,多个之间使用分隔符隔开")
    private String names;
    @ApiModelProperty(notes = "公司编码序列,多个之间使用分隔符隔开")
    private String codes;
    @ApiModelProperty(notes = "所属区域")
    private String areaId;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "备注")
    private String remark;
}
