package com.gccloud.starter.common.module.config.dto;

import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 参数配置
 *
 * @Author liuchengbiao
 * @Date 2020-07-07
 * @Version 1.0.0
 */
@Data
@ToString(callSuper = true)
public class SysConfigDTO implements Serializable {
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "参数键名")
    @NotBlank(message = "参数键名不能为空", groups = {Insert.class, Update.class})
    private String configKey;
    @ApiModelProperty(notes = "参数键值")
    @NotBlank(message = "参数键值不能为空", groups = {Insert.class, Update.class})
    private String configValue;
    @ApiModelProperty(notes = "是否系统内置(1是系统内置，0不是系统内置)")
    private Boolean sys = Boolean.FALSE;
    @ApiModelProperty(notes = "参数名称")
    @NotBlank(message = "参数名称不能为空", groups = {Insert.class, Update.class})
    private String remark;
}
