package com.gccloud.starter.common.module.dict.dto;

import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import com.gccloud.starter.common.validator.module.dict.Code;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 业务字典项
 *
 * @Author liuchengbiao
 * @Date 2020-07-07
 * @Version 1.0.0
 */
@Data
@ToString(callSuper = true)
public class SysDictItemDTO implements Serializable {
    @ApiModelProperty(notes = "主键")
    @NotBlank(message = "ID不能为空", groups = {Update.class})
    private String id;
    @ApiModelProperty(notes = "业务字典编码")
    @Code(message = "{gc.starter.validator.dict.code.message}", groups = {Insert.class, Update.class})
    @NotBlank(message = "业务字典编码不能为空", groups = {Insert.class, Update.class})
    private String dictCode;
    @ApiModelProperty(notes = "业务字典项名称")
    @NotBlank(message = "业务字典项名称不能为空", groups = {Insert.class, Update.class})
    private String name;
    @ApiModelProperty(notes = "业务字典项值")
    @NotBlank(message = "业务字典项值不能为空", groups = {Insert.class, Update.class})
    private String value;
    @ApiModelProperty(notes = "业务字典描述")
    private String remark;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "状态,0正常，1禁用")
    @NotNull(message = "业务字典项状态不能为空", groups = {Insert.class, Update.class})
    private Integer status;
}
