package com.gccloud.starter.common.module.dict.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.ToString;

import java.io.Serializable;

/**
 * 业务字典项
 *
 * @Author liuchengbiao
 * @Date 2020-07-07
 * @Version 1.0.0
 */
@Data
@ToString(callSuper = true)
@ApiModel
public class SysDictItemVO implements Serializable {
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "业务字典编码")
    private String dictCode;
    @ApiModelProperty(notes = "业务字典项名称")
    private String name;
    @ApiModelProperty(notes = "业务字典项值")
    private String value;
    @ApiModelProperty(notes = "业务字典描述")
    private String remark;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "状态,0正常，1禁用")
    private Integer status;
}
