package com.gccloud.starter.common.module.forgotPwd.dto;

import com.gccloud.starter.common.validator.annotation.UUID;
import com.gccloud.starter.common.validator.group.Uuid;
import com.gccloud.starter.common.validator.module.user.Email;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 邮箱找回密码
 *
 * @author liuchengbiao
 * @date 2021/6/7 4:17 下午
 */
@Data
public class SysForgotPwdEmailDTO implements Serializable {
    @ApiModelProperty(notes = "邮箱")
    @Email(message = "{gc.starter.validator.user.email.message}")
    private String email;
    @ApiModelProperty(notes = "UUID")
    @UUID(groups = {Uuid.class})
    private String uuid;
    @ApiModelProperty(notes = "验证码")
    @NotBlank(message = "验证码不能为空")
    private String captcha;
    @ApiModelProperty(notes = "密码")
    @NotBlank(message = "密码不能为空")
    private String password;
}
