package com.gccloud.starter.common.module.log.vo;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.ser.std.ToStringSerializer;
import com.gccloud.starter.common.constant.GlobalConst;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Author tang.jiawen
 * @Date 2020/7/14
 * @Version 1.0.0
 */
@Data
public class SysLogVO implements Serializable {

    @ApiModelProperty(notes = "ID")
    private String id;

    @ApiModelProperty(notes = "日志类型")
    private Integer type;

    /**
     * 参考 {@link GlobalConst.Log.State}
     * 可以后面进行扩展
     */
    @ApiModelProperty(notes = "日志状态")
    private Integer state = GlobalConst.Log.State.NORMAL;

    @ApiModelProperty(notes = "用户昵称")
    private String realName;

    @ApiModelProperty(notes = "模块名")
    private String module;

    @ApiModelProperty(notes = "操作")
    private String operation;

    @ApiModelProperty(notes = "调用方法")
    private String method;

    @ApiModelProperty(notes = "客户端IP")
    private String clientIp;

    @ApiModelProperty(notes = "设备名称")
    private String deviceName;

    @ApiModelProperty(notes = "浏览器名称")
    private String browserName;

    @ApiModelProperty(notes = "请求地址")
    private String requestUri;

    @ApiModelProperty(notes = "请求参数")
    private String params;

    @ApiModelProperty(notes = "耗时")
    @JsonSerialize(using = ToStringSerializer.class)
    private Long elapsedTime;

    @ApiModelProperty(notes = "异常信息")
    private String exception;

    @ApiModelProperty(notes = "创建时间")
    private Date createDate;
}
