package com.gccloud.starter.common.module.login.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.annotation.UUID;
import com.gccloud.starter.common.validator.group.Captcha;
import com.gccloud.starter.common.validator.group.Uuid;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 账号登录（账号可以是邮箱、手机、账户）
 */
@Data
@ApiModel
public class SysAccountLoginDTO implements Serializable {
    @ApiModelProperty(notes = "用户名")
    @NotBlank(message = "用户名不能为空")
    private String username;
    @ApiModelProperty(notes = "密码")
    @NotBlank(message = "密码不能为空")
    private String password;
    @ApiModelProperty(notes = "验证码")
    @NotBlank(message = "验证码不能为空", groups = {Captcha.class})
    private String captcha;
    @ApiModelProperty(notes = "UUID")
    @UUID(groups = {Uuid.class})
    private String uuid;
    @ApiModelProperty(notes = "终端类型")
    private String terminal;

    public String getTerminal() {
        if (StringUtils.isBlank(terminal)) {
            return GlobalConst.Login.DefaultTerminal.PC;
        }
        return terminal;
    }
}
