package com.gccloud.starter.common.module.login.dto;

import com.gccloud.starter.common.validator.module.user.Email;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 邮箱登录验证码
 */
@Data
@ApiModel
public class SysEmailCaptchaDTO implements Serializable {
    @ApiModelProperty(notes = "邮箱")
    @NotBlank(message = "邮箱不能为空")
    @Email(message = "{gc.starter.validator.user.email.message}")
    private String email;
    @ApiModelProperty(notes = "来源类型，1：登录 2：注册 3：找回密码")
    @NotNull(message = "来源类型不能为空")
    private Integer fromType;
}
