package com.gccloud.starter.common.module.login.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.module.user.Email;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 邮箱登录
 */
@Data
@ApiModel
public class SysEmailLoginDTO implements Serializable {
    @ApiModelProperty(notes = "邮箱")
    @NotBlank(message = "邮箱不能为空")
    @Email(message = "{gc.starter.validator.user.email.message}")
    private String email;
    @ApiModelProperty(notes = "验证码")
    @NotBlank(message = "验证码不能为空")
    private String captcha;
    @ApiModelProperty(notes = "终端类型")
    private String terminal;

    public String getTerminal() {
        if (StringUtils.isBlank(terminal)) {
            return GlobalConst.Login.DefaultTerminal.PC;
        }
        return terminal;
    }
}
