package com.gccloud.starter.common.module.login.dto;

import com.gccloud.starter.common.validator.module.user.Phone;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 手机号获取验证码
 */
@Data
@ApiModel
public class SysPhoneCaptchaDTO implements Serializable {
    @ApiModelProperty(notes = "手机号")
    @NotBlank(message = "手机号不能为空")
    @Phone(message = "{gc.starter.validator.user.phone.message}")
    private String phone;
    @ApiModelProperty(notes = "来源类型，1：登录 2：注册 3：找回密码")
    @NotNull(message = "来源类型不能为空")
    private Integer fromType;
}
