package com.gccloud.starter.common.module.login.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.validator.module.user.Phone;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 手机号登录
 */
@Data
@ApiModel
public class SysPhoneLoginDTO implements Serializable {
    @ApiModelProperty(notes = "手机号")
    @NotBlank(message = "手机号不能为空")
    @Phone(message = "{gc.starter.validator.user.phone.message}")
    private String phone;
    @ApiModelProperty(notes = "验证码")
    @NotBlank(message = "验证码不能为空")
    private String captcha;
    @ApiModelProperty(notes = "终端类型")
    private String terminal;

    public String getTerminal() {
        if (StringUtils.isBlank(terminal)) {
            return GlobalConst.Login.DefaultTerminal.PC;
        }
        return terminal;
    }
}
