package com.gccloud.starter.common.module.menu.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.entity.ExtendObj;
import com.gccloud.starter.common.validator.group.Insert;
import com.gccloud.starter.common.validator.group.Update;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * 菜单管理
 *
 * @Author tang.jiawen
 * @Date 2020/7/2
 * @Version 1.0.0
 */
@Data
@ApiModel
public class SysMenuDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;
    @ApiModelProperty(notes = "菜单名称")
    @NotBlank(message = "菜单名称不能为空", groups = {Insert.class, Update.class})
    private String name;
    @ApiModelProperty(notes = "上级菜单或目录ID")
    @NotBlank(message = "上级菜单或目录不能为空", groups = {Insert.class, Update.class})
    private String parentId;
    @ApiModelProperty(notes = "访问路径")
    private String path;
    @NotNull(message = "菜单类型不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "菜单类型,类型 0：目录 1：菜单 2：按钮")
    private Integer type;
    /**
     * 是否是聚合路由
     * 参考 {@link GlobalConst.Menu.MergeRoute}
     */
    @NotNull(message = "聚合路由类型不能为空", groups = {Insert.class, Update.class})
    @ApiModelProperty(notes = "聚合路由, 0：否 1：是")
    private Integer mergeRoute;
    @ApiModelProperty(notes = "菜单编码")
    private String code;
    @ApiModelProperty(notes = "组件地址")
    private String component;
    @ApiModelProperty(notes = "外链地址")
    private String iframeUrl;
    @ApiModelProperty(notes = "首页设置(不设置系统自动解析)")
    private Boolean home;
    @ApiModelProperty(notes = "顶部显示(特定布局生效)")
    private Boolean top;
    @ApiModelProperty(notes = "菜单参数")
    private ExtendObj params;
    @ApiModelProperty(notes = "授权(多个用逗号分隔，如：user:list,user:create)")
    private String permissions;
    @ApiModelProperty(notes = "菜单或目录图标")
    private String icon;
    @ApiModelProperty(notes = "文本提醒是否启用")
    private Boolean tipDisabled;
    /**
     * 文本提醒的内容来源，支持SQL、java bean、固定值
     * 参考{@link GlobalConst.Menu.TipFrom}
     */
    @ApiModelProperty(notes = "文本提醒信息来源")
    private Integer tipFrom;
    /**
     * 用于在菜单的右侧显示的提醒文本
     */
    @ApiModelProperty(notes = "文本提醒来源脚本")
    private String tipScript;
    @ApiModelProperty(notes = "菜单打开方式")
    private String target;
    @ApiModelProperty(notes = "是否缓存（1：缓存; 0:不缓存）")
    private Boolean keepAlive;
    @ApiModelProperty(notes = "菜单是否隐藏(1: 隐藏; 0: 显示)")
    private Boolean hide;
    @ApiModelProperty(notes = "是否禁用(1: 禁用,0: 正常)")
    private Boolean disabled;
    @ApiModelProperty(notes = "包裹组件地址")
    private String wrapComponent;
    @ApiModelProperty(notes = "菜单排序")
    private Integer orderNum = 1000;
    @ApiModelProperty(notes = "菜单说明")
    private String remark;
    // 数据规则属性
    @ApiModelProperty(notes = "规则编码")
    private String ruleCode;
    @ApiModelProperty(notes = "规则字段")
    private String ruleColumn;
    /**
     * 参考 {@link GlobalConst.Menu.RuleCondition}
     */
    @ApiModelProperty(notes = "规则条件")
    private String ruleCondition;
    @ApiModelProperty(notes = "规则值")
    private String ruleValue;
}
