package com.gccloud.starter.common.module.menu.vo;

import com.gccloud.starter.common.vo.TreeVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 菜单管理
 *
 * @Author tang.jiawen
 * @Date 2020/7/9
 * @Version 1.0.0
 */

@Data
@ApiModel
public class SysMenuVO implements TreeVo<SysMenuVO>, Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "主键")
    private String id;
    @ApiModelProperty(notes = "菜单名称")
    private String name;
    @ApiModelProperty(notes = "菜单类型,类型 0：目录 1：菜单 2：按钮 3: 数据规则")
    private Integer type;
    @ApiModelProperty(notes = "菜单编码")
    private String code;
    @ApiModelProperty(notes = "访问路径")
    private String path;
    @ApiModelProperty(notes = "权限")
    private String permissions;
    @ApiModelProperty(notes = "父菜单ID")
    private String parentId;
    @ApiModelProperty(notes = "父菜单名称")
    private String parentName;
    @ApiModelProperty(notes = "排序")
    private Integer orderNum;
    @ApiModelProperty(notes = "子菜单集合")
    private List<SysMenuVO> children;
    @ApiModelProperty(notes = "规则编码")
    private String ruleCode;
    @ApiModelProperty(notes = "模块编码")
    private String moduleCode;
}
