package com.gccloud.starter.common.module.module.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

/**
 * @Author zhangtaozhir
 * @Description //TODO
 * @Date 16:35 2022/1/15
 * @Param
 * @return
 **/
@Data
public class SysModuleDTO  implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(notes = "主键")
    private String id;

    @ApiModelProperty(notes = "模块编码")
    @NotBlank(message = "模块编码不能为空")
    private String moduleCode;

    @ApiModelProperty(notes = "模块名称")
    @NotBlank(message = "模块名称不能为空")
    private String moduleName;

    @ApiModelProperty(notes = "是否使用，0禁用，1启用")
    @NotNull(message = "状态不能为空")
    private Integer status;

    @ApiModelProperty(notes = "备注")
    private String remark;
}