package com.gccloud.starter.common.module.monitor.aop;

import lombok.Data;

import java.util.concurrent.atomic.AtomicLong;

@Data
public class MethodMonitorDTO {
    /**
     * 方法名
     */
    private String methodName;
    /**
     * 平均耗时
     */
    private Long avgElapsedTime = 0L;
    /**
     * 总耗时
     */
    private AtomicLong totalElapsedTime = new AtomicLong(0);
    /**
     * 触发次数
     */
    private AtomicLong exeCount = new AtomicLong(0);
    /**
     * 异常次数
     */
    private AtomicLong exceptionCount = new AtomicLong(0);
    /**
     * 超过5秒调用次数
     */
    private AtomicLong ge5sCount = new AtomicLong(0);
    /**
     * 超过4秒调用次数
     */
    private AtomicLong ge4sCount = new AtomicLong(0);
    /**
     * 超过3秒调用次数
     */
    private AtomicLong ge3sCount = new AtomicLong(0);
    /**
     * 超过2秒调用次数
     */
    private AtomicLong ge2sCount = new AtomicLong(0);
    /**
     * 超过1秒调用次数
     */
    private AtomicLong ge1sCount = new AtomicLong(0);
    /**
     * 升序
     */
    public static final String SORT_ASC = "asc";
    /**
     * 降序
     */
    public static final String SORT_DESC = "desc";
}
