package com.gccloud.starter.common.module.monitor.controller;

import com.gccloud.starter.common.vo.R;
import com.gccloud.starter.common.module.monitor.service.ISysMonitorService;
import com.gccloud.starter.common.module.monitor.vo.MonitorVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiSort;
import lombok.extern.slf4j.Slf4j;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * @author liuchengbiao
 * @date 2021/9/23 11:57 上午
 */
@RestController
@RequestMapping("/sys/monitor")
@Api(tags = "系统监控")
@ApiSort(value = 200)
@Slf4j
public class SysMonitorController {

    @Resource
    private ISysMonitorService sysMonitorService;

    /**
     * 获取监控数据
     *
     * @return
     */
    @GetMapping(value = {"/", ""})
    @ApiOperation(value = "获取监控数据", position = 20, notes = "获取监控数据", produces = MediaType.APPLICATION_JSON_VALUE)
    public R<MonitorVo> getData() {
        MonitorVo data = sysMonitorService.getData();
        return R.success(data);
    }
}
