package com.gccloud.starter.common.module.monitor.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

/**
 * @author liuchengbiao
 * @date 2021/9/23 11:42 上午
 */
@Data
public class MonitorVo implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * CPU相关信息
     */
    private CpuVo cpu = new CpuVo();

    /**
     * 內存相关信息
     */
    private MemoryVo memory = new MemoryVo();

    /**
     * JVM相关信息
     */
    private JvmVo jvm = new JvmVo();

    /**
     * 服务器相关信息
     */
    private SystemVo system = new SystemVo();

    /**
     * 磁盘相关信息
     */
    private List<FileSystemVo> fileSystemList = new LinkedList<FileSystemVo>();
    /**
     * 监控的时间
     */
    private Date date;
}
