package com.gccloud.starter.common.module.notice.dto;

import com.gccloud.starter.common.constant.GlobalConst;
import com.gccloud.starter.common.module.file.vo.AttachmentFile;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 公告
 *
 * @author renxx
 * @data 2021/9/8 10:26
 */
@Data
public class SysNoticeDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "ID")
    private String id;
    @ApiModelProperty(notes = "公告标题")
    @NotBlank(message = "公告标题不能为空")
    private String title;
    @ApiModelProperty(notes = "公告内容")
    @NotBlank(message = "公告内容不能为空")
    private String content;
    @ApiModelProperty(value = "公告类型")
    @NotBlank(message = "公告栏目不能为空")
    private String type;
    @ApiModelProperty(value = "摘要")
    private String digest;
    @ApiModelProperty(value = "发布者名")
    private String publisher;
    /**
     * 参考 {@link GlobalConst.Notice.Stick}
     */
    @ApiModelProperty(notes = "0：默认;1：置顶")
    private Integer stickTop;
    /**
     * 参考 {@link GlobalConst.Notice.Status}
     */
    @ApiModelProperty(notes = "公告状态,0在线，1草稿，2下线")
    private Integer status;
    @ApiModelProperty(notes = "开始时间")
    private Date startDate;
    @ApiModelProperty(notes = "结束时间")
    private Date endDate;
    @ApiModelProperty(notes = "是否开启回复,1开启，0禁止")
    private Integer replyEnable;
    @ApiModelProperty(notes = "附件")
    private List<AttachmentFile> attachments;
}
