package com.gccloud.starter.common.module.notice.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

/**
 * 通告回复
 *
 * @Author qianxing
 * @Date 2021/09/07
 * @Version 1.0.0
 */
@Data
public class SysNoticeReplyDTO implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(notes = "公告id")
    @NotBlank(message = "公告id不能为空")
    private String noticeId;
    @ApiModelProperty(notes = "评论内容")
    @NotBlank(message = "评论内容不能为空")
    private String content;
}